//
//  main.cpp
//  FreecellTerminal
//
//  Created by Jeff Sandler on 12/31/14.
//  Copyright (c) 2014 Jeff Sandler. All rights reserved.
//

#include <iostream>
#include "Card.h"
#include "cardSpot.h"
#include <stdlib.h>     /* srand, rand */
#include <string>
#include <time.h>
#include <math.h>
using namespace std;
//------------------------------------------GLOBAL VARIABLES--------------------------------------------
Card theDeck[52];
Card theShuffledDeck[52];
cardSpot theFreecells[4];
cardSpot theColumns[8][19];//7 cards dealt plus as many as 12 more placed on top
int cardsInColumns[8];
cardSpot theStacks[4];
string userInput = "";
char userInput2[2] = "";
int componentsOfUserInput[4];
bool goodMove, keepLooping;
int counter, availableCells;
string badMoveString;
long int startSeconds, endSeconds;
bool stillClean;
int cleanLevel;
bool sentCleanMessage;
int highestCardInColumn;
int lowestBlankInColumn;
//------------------------------------------PROTOTYPES--------------------------------------------------
void createDeck();//creates an array of 52 Cards in order from Ac to Ks
void shuffleAndDeal();//It's pretty hard to tell what this does.
void manualDeal();
void updateDisplay();
void getUserInteraction();//This is where the game is played.  This method contains an endless loop and the only way out is to end the program.
string convertToCardNumber(int);
string convertToCardSuit(int);
void moveCards();
bool willStackInColumnFashion(Card,Card);
bool willStackInStackFashion(cardSpot,cardSpot);
void moveDownFromHere(int sentColumn,int sentPosition);
//------------------------------------------------------------------------------------------------------
int main(int argc, const char * argv[])
{
	createDeck(); //creates 52 cards and puts them in an array

	do
	{
		cout << "Choose 1 by entering the 1st letter:" << endl << "Random deal" << endl << "Manual deal" << endl;
		getline(cin,userInput);
	}while(userInput != "r" and userInput != "m" and userInput != "R" and userInput !="M");
	if(userInput == "r" or userInput == "R")
	{
		shuffleAndDeal(); //I wonder what this does!
	}
	else//no need to check NEthing here.  The loop above won't end until the user has entered m,M,r or R.  The if() statement above elimates r and R.
	{
		manualDeal();//
	}
	startSeconds = time(NULL);
	updateDisplay();
	getUserInteraction(); //the game plays within this method.  It will stay in a loop until the program ends.
	return 0;
}//closes main(

void createDeck()
{
	cleanLevel = 1;//This is initializing this integer.  It will increment from here.
	sentCleanMessage = false;//Initializing this, too.  I guess this has become the unofficial place to initialize things.
	int counter = 0;
	for(int o = 0;o < 13;o++)
	{
		for(int i = 0;i < 4;i++)
		{
			theDeck[counter] = Card(o,i);
			counter++;
		}//closes inside loop
	}//closes outside loop
	for(int i = 0;i < 4;i++)//initializing the freecells
	{
		theFreecells[i].placeCard(Card());
	}
	for(int i = 0;i < 4;i++)//initializing the stacks
	{
		theStacks[i].placeCard(Card(-1,i));
	}
	return;
}//closes createDeck

void moveDownFromHere(int sentColumn,int sentPosition)
{
	int currentIndex = sentPosition;//
	while(currentIndex < 18)
	{
		Card tempCard = Card(theColumns[sentColumn][currentIndex+1].getNumber(),theColumns[sentColumn][currentIndex+1].getSuit());
		theColumns[sentColumn][currentIndex].placeCard(tempCard);
		currentIndex++;
	}
	theColumns[sentColumn][18].placeCard(Card());//this makes the top position a non-card.  This is never wrong, but sometimes unnecessary.  Sometimes it's absolutely necessary.
	return;
}//closes moveDownFromHere(argument,argument
void manualDeal()
{
	stillClean = true;
	srand (time(NULL));/* initialize random seed: */
	//THIS IS WHERE THE CODE GOES TO ASK FOR THE POSITIONS OF ALL THE CARDS.  OY!!!!!!!!!!!!!!!!!!-------------------------------------------------------------------
	bool goodPlay;
	for(int i = 0;i<52;i++)
	{
		goodPlay = true; //innocent until proven not a good play!
		userInput = "";
		while(userInput != "f" and userInput != "F " and userInput != "c" and userInput != "C" and userInput != "s" and userInput != "S")
		{
			cout << endl << endl << "Enter the place for each card in the deck." << endl << "Freecell" << endl << "Column" << endl << "Stack" << endl;
			cout << endl << "Where do you want the " << convertToCardNumber(theDeck[i].getNumber()) << convertToCardSuit(theDeck[i].getSuit()) << " ?";
			getline(cin,userInput);
		}
			if(userInput == "f" or userInput == "F")//user chose freecell
			{
				int x = 0;//I needed to declare this here because I'm testing it outside the for() loop;  If I create it in the for() statement, it only exists in the loop.
				for(x=0;x<4;x++)//checking four freecells to find an empty one
				{
					if(theFreecells[x].getNumber() == -1)//IOW, if we found a good one
					{
						goodPlay = true; //it already is, this is redundant
						theFreecells[x].placeCard(Card(theDeck[i].getNumber(),theDeck[i].getSuit()));
						x=10;//this will break out of the for() loop since we don't need to check any more.  I used 10 so I can test it against falling out of the loop naturally.
					}
				}
				if(x < 10)
				{
					goodPlay = false;
					cout << endl << "All freecells are full.  Put it somewhere else." << endl;
				}
			}//closes if(userInput == F
			if(userInput == "s" or userInput == "S")//user chose stack
			{
				cardSpot justForThis;//I need a cardSpot because it's a parameter to willStackInStackFashion()
				justForThis.placeCard(theDeck[i]);
				if(willStackInStackFashion(theStacks[theDeck[i].getSuit()],justForThis))//stationary card, moving card
				{
					theStacks[theDeck[i].getSuit()].placeCard(theDeck[i]);
					goodPlay = true;
				}
				else
				{
					goodPlay = false;
					cout << endl << "Stack not ready for that card." << endl;
				}
			}//closes if(UI == S
			if(userInput == "c" or userInput == "C")
			{
				while(userInput != "1" and userInput != "2" and userInput != "3" and userInput != "4" and userInput != "5" and userInput != "6" and userInput != "7" and userInput != "8")
				{
					cout << endl << "Which column? (1 - 8)" << endl;
					getline(cin,userInput);
				}//closes while(UI != one through eight)
				int calculatedColumnNumber = 0;//the IDE complains if I don't initialize.
				if(userInput == "1")//at this point, userInput is guaranteed to be "1" thru "8"
					calculatedColumnNumber = 0;
				if(userInput == "2")
					calculatedColumnNumber = 1;	//WHAT
				if(userInput == "3")
					calculatedColumnNumber = 2;
				if(userInput == "4")
					calculatedColumnNumber = 3;//			A
				if(userInput == "5")
					calculatedColumnNumber = 4;
				if(userInput == "6")
					calculatedColumnNumber = 5;//				PAIN IN
				if(userInput == "7")
					calculatedColumnNumber = 6;
				if(userInput == "8")
					calculatedColumnNumber = 7;//						THE ASS!!!!!!!!!
				userInput = "";
				string userColumnNumber = "";
				while(userInput != "1" and userInput != "2" and userInput != "3" and userInput != "4" and userInput != "5" and userInput != "6" and userInput != "7" and userInput != "8" and userInput != "9" and userInput != "10" and userInput != "11" and userInput != "12" and userInput != "13" and userInput != "14" and userInput != "15" and userInput != "16" and userInput != "17" and userInput != "18" and userInput != "19")
				{
					cout << endl << "Which position on column " << userColumnNumber << "? (1 - 19)" << endl;
					getline(cin,userInput);
				}//closes while(UI != one through 19)
				int calculatedPosition = 0;//the IDE complains if I don't initialize
				if(userInput == "1")
					calculatedPosition = 0;
				if(userInput == "2")
					calculatedPosition = 1;
				if(userInput == "3")
					calculatedPosition = 2;
				if(userInput == "4")
					calculatedPosition = 3;
				if(userInput == "5")
					calculatedPosition = 4;
				if(userInput == "6")
					calculatedPosition = 5;
				if(userInput == "7")
					calculatedPosition = 6;
				if(userInput == "8")
					calculatedPosition = 7;
				if(userInput == "9")
					calculatedPosition = 8;
				if(userInput == "10")
					calculatedPosition = 9;
				if(userInput == "11")
					calculatedPosition = 10;
				if(userInput == "12")
					calculatedPosition = 11;
				if(userInput == "13")
					calculatedPosition = 12;
				if(userInput == "14")
					calculatedPosition = 13;
				if(userInput == "15")
					calculatedPosition = 14;
				if(userInput == "16")
					calculatedPosition = 15;
				if(userInput == "17")
					calculatedPosition = 16;
				if(userInput == "18")
					calculatedPosition = 17;
				if(userInput == "19")
					calculatedPosition = 18;
				if(theColumns[calculatedColumnNumber][calculatedPosition].getNumber() == -1)//(theCard@position calculatedColumnNumber,calculatedPosition.getNumber() == -1)
				{
					theColumns[calculatedColumnNumber][calculatedPosition].placeCard(Card(theDeck[i].getNumber(),theDeck[i].getSuit()));//place the card here
					cardsInColumns[calculatedColumnNumber]++;
					goodPlay = true;
				}
				else//IOW, the card is NOT -1, IOOW, there is already a card at that position
				{
					cout << endl << "That position is occupied.  Place it somewhere else." << endl;
					goodPlay = false;
				}
			}//closes if(UI == "c"
		if(goodPlay == false)
		{
			i--;
		}
	updateDisplay();
	}//closes for(i=0;i<52)
	//---------------------------------------------this is where we check for empty spaces in the columns and compress the cards above to remove them-----------------

	for(int colNum = 0;colNum < 8;colNum++)//eight columns obviously
	{
		do
		{
			highestCardInColumn = -1;//Not zero.  Zero is a valid position.  -1 means no cards.
			lowestBlankInColumn = 19;//18 is the highest possible value.  19 means no blanks.
			//from here, find the position of the highest card and the lowest blank.  If they're not right yet, call a function to compress starting at the lowest blank.
			for(int k=0;k<19;k++)
			{
				if(theColumns[colNum][k].getNumber() != -1)
				{
					highestCardInColumn = k;
				}//closes if(blahblah != -1
			}//closes k < 19
			for(int k=18;k>-1;k--)//start at the top of the column and work downward.
			{
				if(theColumns[colNum][k].getNumber() == -1)
				{
					lowestBlankInColumn = k;
				}//closes if(blahblah == -1
			}//closes k > -1
			if(highestCardInColumn > lowestBlankInColumn)
			{//if not, just fall through
				moveDownFromHere(colNum,lowestBlankInColumn);
			}//closes if(
			//cout << endl << "For column " << colNum << ", the highest number is " << highestCardInColumn << " and the lowest blank is " << lowestBlankInColumn << "." << endl;
		}while(highestCardInColumn > lowestBlankInColumn);
	}
//	exit(0);
	return;
}//closes manualDeal()

void shuffleAndDeal()//theShuffledDeck,theDeck
{
	stillClean = true;
	bool gotOne = false;
	srand (time(NULL));/* initialize random seed: */
	int randomNumber;

	for(int i=0;i<52;i++)
	{
		while(!gotOne)
		{
			randomNumber = rand() % 52;//generates a "random" from 0 to 51.
			if(theDeck[randomNumber].getNumber() != -1)//IOW, it's a valid number; I could have tested the suit instead
			{
				theShuffledDeck[i] = Card(theDeck[randomNumber].getNumber(),theDeck[randomNumber].getSuit());
				theDeck[randomNumber] = Card();//this will make it -1,-1
				gotOne = true;
			}
		}//closes while(!gotOne)
		gotOne = false;
	}//closes for(
//----------------above is shuffling and below is dealing-------------------------------------------------
	for(int i = 0;i < 8;i++)
	{
		cardsInColumns[i] = 0;
	}//closes for(
	theColumns[0][0].placeCard(Card(theShuffledDeck[0].getNumber(),theShuffledDeck[0].getSuit()));
	cardsInColumns[0]++;
	theColumns[1][0].placeCard(Card(theShuffledDeck[1].getNumber(),theShuffledDeck[1].getSuit()));
	cardsInColumns[1]++;
	theColumns[2][0].placeCard(Card(theShuffledDeck[2].getNumber(),theShuffledDeck[2].getSuit()));
	cardsInColumns[2]++;
	theColumns[3][0].placeCard(Card(theShuffledDeck[3].getNumber(),theShuffledDeck[3].getSuit()));
	cardsInColumns[3]++;
	theColumns[4][0].placeCard(Card(theShuffledDeck[4].getNumber(),theShuffledDeck[4].getSuit()));
	cardsInColumns[4]++;
	theColumns[5][0].placeCard(Card(theShuffledDeck[5].getNumber(),theShuffledDeck[5].getSuit()));
	cardsInColumns[5]++;
	theColumns[6][0].placeCard(Card(theShuffledDeck[6].getNumber(),theShuffledDeck[6].getSuit()));
	cardsInColumns[6]++;
	theColumns[7][0].placeCard(Card(theShuffledDeck[7].getNumber(),theShuffledDeck[7].getSuit()));
	cardsInColumns[7]++;
	theColumns[0][1].placeCard(Card(theShuffledDeck[8].getNumber(),theShuffledDeck[8].getSuit()));
	cardsInColumns[0]++;
	theColumns[1][1].placeCard(Card(theShuffledDeck[9].getNumber(),theShuffledDeck[9].getSuit()));
	cardsInColumns[1]++;
	theColumns[2][1].placeCard(Card(theShuffledDeck[10].getNumber(),theShuffledDeck[10].getSuit()));
	cardsInColumns[2]++;
	theColumns[3][1].placeCard(Card(theShuffledDeck[11].getNumber(),theShuffledDeck[11].getSuit()));
	cardsInColumns[3]++;
	theColumns[4][1].placeCard(Card(theShuffledDeck[12].getNumber(),theShuffledDeck[12].getSuit()));
	cardsInColumns[4]++;
	theColumns[5][1].placeCard(Card(theShuffledDeck[13].getNumber(),theShuffledDeck[13].getSuit()));
	cardsInColumns[5]++;
	theColumns[6][1].placeCard(Card(theShuffledDeck[14].getNumber(),theShuffledDeck[14].getSuit()));
	cardsInColumns[6]++;
	theColumns[7][1].placeCard(Card(theShuffledDeck[15].getNumber(),theShuffledDeck[15].getSuit()));
	cardsInColumns[7]++;
	theColumns[0][2].placeCard(Card(theShuffledDeck[16].getNumber(),theShuffledDeck[16].getSuit()));
	cardsInColumns[0]++;
	theColumns[1][2].placeCard(Card(theShuffledDeck[17].getNumber(),theShuffledDeck[17].getSuit()));
	cardsInColumns[1]++;
	theColumns[2][2].placeCard(Card(theShuffledDeck[18].getNumber(),theShuffledDeck[18].getSuit()));
	cardsInColumns[2]++;
	theColumns[3][2].placeCard(Card(theShuffledDeck[19].getNumber(),theShuffledDeck[19].getSuit()));
	cardsInColumns[3]++;
	theColumns[4][2].placeCard(Card(theShuffledDeck[20].getNumber(),theShuffledDeck[20].getSuit()));
	cardsInColumns[4]++;
	theColumns[5][2].placeCard(Card(theShuffledDeck[21].getNumber(),theShuffledDeck[21].getSuit()));
	cardsInColumns[5]++;
	theColumns[6][2].placeCard(Card(theShuffledDeck[22].getNumber(),theShuffledDeck[22].getSuit()));
	cardsInColumns[6]++;
	theColumns[7][2].placeCard(Card(theShuffledDeck[23].getNumber(),theShuffledDeck[23].getSuit()));
	cardsInColumns[7]++;
	theColumns[0][3].placeCard(Card(theShuffledDeck[24].getNumber(),theShuffledDeck[24].getSuit()));
	cardsInColumns[0]++;
	theColumns[1][3].placeCard(Card(theShuffledDeck[25].getNumber(),theShuffledDeck[25].getSuit()));
	cardsInColumns[1]++;
	theColumns[2][3].placeCard(Card(theShuffledDeck[26].getNumber(),theShuffledDeck[26].getSuit()));
	cardsInColumns[2]++;
	theColumns[3][3].placeCard(Card(theShuffledDeck[27].getNumber(),theShuffledDeck[27].getSuit()));
	cardsInColumns[3]++;
	theColumns[4][3].placeCard(Card(theShuffledDeck[28].getNumber(),theShuffledDeck[28].getSuit()));
	cardsInColumns[4]++;
	theColumns[5][3].placeCard(Card(theShuffledDeck[29].getNumber(),theShuffledDeck[29].getSuit()));
	cardsInColumns[5]++;
	theColumns[6][3].placeCard(Card(theShuffledDeck[30].getNumber(),theShuffledDeck[30].getSuit()));
	cardsInColumns[6]++;
	theColumns[7][3].placeCard(Card(theShuffledDeck[31].getNumber(),theShuffledDeck[31].getSuit()));
	cardsInColumns[7]++;
	theColumns[0][4].placeCard(Card(theShuffledDeck[32].getNumber(),theShuffledDeck[32].getSuit()));
	cardsInColumns[0]++;
	theColumns[1][4].placeCard(Card(theShuffledDeck[33].getNumber(),theShuffledDeck[33].getSuit()));
	cardsInColumns[1]++;
	theColumns[2][4].placeCard(Card(theShuffledDeck[34].getNumber(),theShuffledDeck[34].getSuit()));
	cardsInColumns[2]++;
	theColumns[3][4].placeCard(Card(theShuffledDeck[35].getNumber(),theShuffledDeck[35].getSuit()));
	cardsInColumns[3]++;
	theColumns[4][4].placeCard(Card(theShuffledDeck[36].getNumber(),theShuffledDeck[36].getSuit()));
	cardsInColumns[4]++;
	theColumns[5][4].placeCard(Card(theShuffledDeck[37].getNumber(),theShuffledDeck[37].getSuit()));
	cardsInColumns[5]++;
	theColumns[6][4].placeCard(Card(theShuffledDeck[38].getNumber(),theShuffledDeck[38].getSuit()));
	cardsInColumns[6]++;
	theColumns[7][4].placeCard(Card(theShuffledDeck[39].getNumber(),theShuffledDeck[39].getSuit()));
	cardsInColumns[7]++;
	theColumns[0][5].placeCard(Card(theShuffledDeck[40].getNumber(),theShuffledDeck[40].getSuit()));
	cardsInColumns[0]++;
	theColumns[1][5].placeCard(Card(theShuffledDeck[41].getNumber(),theShuffledDeck[41].getSuit()));
	cardsInColumns[1]++;
	theColumns[2][5].placeCard(Card(theShuffledDeck[42].getNumber(),theShuffledDeck[42].getSuit()));
	cardsInColumns[2]++;
	theColumns[3][5].placeCard(Card(theShuffledDeck[43].getNumber(),theShuffledDeck[43].getSuit()));
	cardsInColumns[3]++;
	theColumns[4][5].placeCard(Card(theShuffledDeck[44].getNumber(),theShuffledDeck[44].getSuit()));
	cardsInColumns[4]++;
	theColumns[5][5].placeCard(Card(theShuffledDeck[45].getNumber(),theShuffledDeck[45].getSuit()));
	cardsInColumns[5]++;
	theColumns[6][5].placeCard(Card(theShuffledDeck[46].getNumber(),theShuffledDeck[46].getSuit()));
	cardsInColumns[6]++;
	theColumns[7][5].placeCard(Card(theShuffledDeck[47].getNumber(),theShuffledDeck[47].getSuit()));
	cardsInColumns[7]++;
	theColumns[0][6].placeCard(Card(theShuffledDeck[48].getNumber(),theShuffledDeck[48].getSuit()));
	cardsInColumns[0]++;
	theColumns[1][6].placeCard(Card(theShuffledDeck[49].getNumber(),theShuffledDeck[49].getSuit()));
	cardsInColumns[1]++;
	theColumns[2][6].placeCard(Card(theShuffledDeck[50].getNumber(),theShuffledDeck[50].getSuit()));
	cardsInColumns[2]++;
	theColumns[3][6].placeCard(Card(theShuffledDeck[51].getNumber(),theShuffledDeck[51].getSuit()));
	cardsInColumns[3]++;
	return;
}//closes shuffleAndDeal()

void updateDisplay()
{
	/*				endSeconds = time(NULL);
	 int minutes = (endSeconds - startSeconds) / 60;
	 int seconds = (endSeconds - startSeconds) % 60;
	 //				cout << "\nGame took " << endSeconds - startSeconds << " seconds.\n";
	 cout << "\nGame took " << minutes << " minutes and " << seconds << " seconds.\n";
*/
	endSeconds = time(NULL);
	int minutesForDisplay = (endSeconds - startSeconds) / 60;
	int secondsForDisplay = (endSeconds - startSeconds) % 60;
	if(minutesForDisplay == 1)
	{
		cout << "1 minute ";
	}
	else
	{
		cout << minutesForDisplay << " minutes ";
	}
	if(secondsForDisplay == 1)
	{
		cout << "1 second";
	}
	else
	{
		cout << secondsForDisplay << " seconds";
	}
	cout << " so far." << endl;
	cout << "  1   2   3   4";
	cout << endl;
	for(int i = 0;i < 4;i++)
	{
		cout << convertToCardNumber(theFreecells[i].getNumber()) << convertToCardSuit(theFreecells[i].getSuit()) << " ";
	}
//---------------------------------------FREECELLS above--------------------------------------------------------------
	cout << "                    ";//20 spaces
	for(int i = 0;i < 4;i++)
	{
		cout << convertToCardNumber(theStacks[i].getNumber()) << convertToCardSuit(theStacks[i].getSuit()) << " ";
	}
	cout << endl;
//--------------------------------------STACKS above-------------------------------------------------------------------
//----------------------------------------------------COLUMNS below----------------------------------------------------
	cout << endl << "       1    2    3    4    5    6    7    8" << endl;
	for(int r = 0;r < 19;r++)
	{
		if(theColumns[0][r].getNumber()==-1 and theColumns[1][r].getNumber()==-1 and theColumns[2][r].getNumber()==-1 and theColumns[3][r].getNumber()==-1 and theColumns[4][r].getNumber()==-1 and theColumns[5][r].getNumber()==-1 and theColumns[6][r].getNumber()==-1 and theColumns[7][r].getNumber()==-1)//if all these are true, the row is blank
		{
			//int a = 37;//pseudonym for do nothing.
		}
		else//IOW, the row is NOT blank
		{
			cout << endl << "     ";
			for(int c =0;c < 8;c++)
			{
				cout << convertToCardNumber(theColumns[c][r].getNumber()) << convertToCardSuit(theColumns[c][r].getSuit()) << "  ";
			}//closes for(
		}//closes else--IOW non-blank row
	}//closes for(r<19) IOW, each time thru this loop is a row of columns
}//closes updateDisplay()

void getUserInteraction()
{
	while(1)//keep looping forever
	{
		goodMove = true;
		for(int i = 0;i < 4;i++)//this loop clears COUI by setting all values to -1
		{
			componentsOfUserInput[i] = -1;
		}
		userInput = "";
		while(userInput != "f" and userInput != "c" and userInput != "q")
		{
			cout << endl << "Move From:" << endl << "Freecell" << endl << "Column" << endl << "Quit" << endl;
			getline(cin,userInput);
		}//closes while(UI!=f,c or q)
		if(userInput == "q")
		{
			exit(0);
		}//closes if(UI == q
		if(userInput == "f")
		{
			componentsOfUserInput[0] = 0;//zero equals freecell, ok?
			userInput = "";
			while(userInput != "1" and userInput != "2" and userInput != "3" and userInput != "4")
			{
				cout << endl << "Which Freecell (1 - 4)?" << endl;
				getline(cin,userInput);
			}//closes while(UI != 1,2,3 or 4
			if(userInput == "1")
				componentsOfUserInput[1] = 0;
			if(userInput == "2")
				componentsOfUserInput[1] = 1;
			if(userInput == "3")
				componentsOfUserInput[1] = 2;
			if(userInput == "4")
				componentsOfUserInput[1] = 3;
			if(theFreecells[componentsOfUserInput[1]].getNumber() == -1)//IOW, the freecell selected is blank
			{
				goodMove = false;
				badMoveString = "selected freecell is blank";
			}
		}//closes if(UI==f
		if(userInput == "c")
		{
			componentsOfUserInput[0] = 2;//two equals columns, ok?
			userInput = "";
			while(userInput != "1" and userInput != "2" and userInput != "3" and userInput != "4" and userInput != "5" and userInput != "6" and userInput != "7" and userInput != "8")
			{
				cout << endl << "Which Column (1 - 8)?" << endl;
				getline(cin,userInput);
			}//closes while(UI != 1,2,3,4,5,6,7 or 8
			if(userInput == "1")
				componentsOfUserInput[1] = 0;
			if(userInput == "2")
				componentsOfUserInput[1] = 1;
			if(userInput == "3")
				componentsOfUserInput[1] = 2;
			if(userInput == "4")
				componentsOfUserInput[1] = 3;
			if(userInput == "5")
				componentsOfUserInput[1] = 4;
			if(userInput == "6")
				componentsOfUserInput[1] = 5;
			if(userInput == "7")
				componentsOfUserInput[1] = 6;
			if(userInput == "8")
				componentsOfUserInput[1] = 7;
			if(cardsInColumns[componentsOfUserInput[1]] == 0)//IOW, the column is empty
			{
				goodMove = false;
				badMoveString = "selected column is blank";
			}
		}//closes if(UI == c
//----------------------------------above is asking where from; below is asking where to---------------------------
		if(goodMove)//this is here because if the move is already bad, there's no reason to ask about the 2nd part of the move.
		{
			updateDisplay();
			userInput = "";
			while(userInput != "f" and userInput != "s" and userInput != "c" and userInput != "q")
			{
				cout << endl << "Move To:" << endl << "Freecell" << endl << "Stack" << endl << "Column" << endl << "Quit" << endl;
				getline(cin,userInput);
			} //closes while(UI != f,s,c or q
			if(userInput == "q")
			{
				exit(0);
			}//closes if(UI = q
			if(userInput == "f")
			{
				componentsOfUserInput[2] = 0;//zero equals freecell, ok?
				bool gotOne = false;
				for(int i = 0;i < 4;i++)
				{
					if(!gotOne)
					{
						if(theFreecells[i].getNumber() == -1)
						{
							componentsOfUserInput[3] = i;
							gotOne = true;
						}//closes if(theFreecells[i]==-1
					}//closes if(!gotOne
				}//closes for(
				//Right here I need to test for gotOne.  If it's still false, that means no available freecell was found.
				if(!gotOne)
				{
					goodMove = false;
					badMoveString = "no vacant freecell available";
				}
			}//closes if(UI=f
			if(userInput == "s")
			{
				componentsOfUserInput[2] = 1;//one is stack, ok?
				if(componentsOfUserInput[0] == 0)//IOW, move from a frecell
				{
					componentsOfUserInput[3] = theFreecells[componentsOfUserInput[1]].getSuit();
					if(!(willStackInStackFashion(theStacks[componentsOfUserInput[3]],theFreecells[componentsOfUserInput[1]]))and theFreecells[componentsOfUserInput[1]].getNumber() != 0)//stationary card first//I checked, and ace returns 0 from getNumber().
					{
						goodMove = false;
						badMoveString = "stack not ready for that card";
					}//closes if(not stackInStackFashion
				}//closes if(COUI = 0
				if(componentsOfUserInput[0] == 2)//IOW, move from a column
				{
					int usefulNumber = cardsInColumns[componentsOfUserInput[1]] - 1;
					componentsOfUserInput[3] = theColumns[componentsOfUserInput[1]][usefulNumber].getSuit();
					if(!(willStackInStackFashion(theStacks[componentsOfUserInput[3]], theColumns[componentsOfUserInput[1]][usefulNumber]))and theColumns[componentsOfUserInput[1]][usefulNumber].getNumber() != 0)
					{
						goodMove = false;
						badMoveString = "stack not ready for that card";
					}//closes if(not stackInStackFashion
				}//closes if(COUI = 2
			}//closes if(UI = s
			if(userInput == "c")
			{
				componentsOfUserInput[2] = 2;//2 means columns, ok?
				userInput = "";
				while(userInput != "1" and userInput != "2" and userInput != "3" and userInput != "4" and userInput != "5" and userInput != "6" and userInput != "7" and userInput != "8" and userInput != "q")
				{
					cout << endl << "Which Column (1 - 8)?" << endl;
					getline(cin,userInput);
				}//closes while(UI != 1,2,3,4,5,6,7,8
				if(userInput=="1")
				{
					componentsOfUserInput[3]=0;
				}
				if(userInput=="2")
				{
					componentsOfUserInput[3]=1;
				}
				if(userInput=="3")
				{
					componentsOfUserInput[3]=2;
				}
				if(userInput=="4")
				{
					componentsOfUserInput[3]=3;
				}
				if(userInput=="5")
				{
					componentsOfUserInput[3]=4;
				}
				if(userInput=="6")
				{
					componentsOfUserInput[3]=5;
				}
				if(userInput=="7")
				{
					componentsOfUserInput[3]=6;
				}
				if(userInput=="8")
				{
					componentsOfUserInput[3]=7;
				}
				if(userInput=="q")
				{
					exit(0);
				}
				if(componentsOfUserInput[0] == 2)//IOW, if moving from a column. IOW, this right here is the dreaded column to column
				{
					//---------------------counting empty freecells-------------------------------------
					int blankFreecells = 0;
					for(int i = 0; i < 4; i++)
					{
						if(theFreecells[i].getNumber() == -1)
						{
							blankFreecells++;
						}
					}//closes for(
					//----------------------counting empty columns--------------------------------------
					int blankColumns = 0;
					for(int i = 0; i < 8; i++)
					{
						if(cardsInColumns[i]==0)
						{
							blankColumns++;
						}
					}
					counter = 0;
					keepLooping = true;
					if(cardsInColumns[componentsOfUserInput[3]] == 0)//IOW, if dest column is blank
					{
					//Two things can cause this loop to end.  Either the card I'm checking doesn't match the card above it or I've gotten to the top of the column.
						counter = 0;
						while(keepLooping)
						{
							if(cardsInColumns[componentsOfUserInput[1]]-2-counter < 0)//this tests if we've reached the last (top) card in the stack.
							{
								keepLooping = false;
							}
							if(keepLooping)
							{
								Card theCardBeingChecked = Card(theColumns[componentsOfUserInput[1]][cardsInColumns[componentsOfUserInput[1]]-1-counter].getNumber(),theColumns[componentsOfUserInput[1]][cardsInColumns[componentsOfUserInput[1]]-1-counter].getSuit());
								Card theCardAbove = Card(theColumns[componentsOfUserInput[1]][cardsInColumns[componentsOfUserInput[1]]-2-counter].getNumber(),theColumns[componentsOfUserInput[1]][cardsInColumns[componentsOfUserInput[1]]-2-counter].getSuit());
								if(willStackInColumnFashion(theCardAbove,theCardBeingChecked))
								{
									counter++;
								}
								else//IOW, the card being checked does not match with the card above it, IOOW, we've already got the last good card in this stack.
								{
									keepLooping=false;
									counter ++;
								}//closes else
							}//closes if(keepLooping
						}//closes while(keepLooping
//--------------------------right here I'll have to determine how many cards can be moved based on freecells and free columns.-----------
						blankColumns--;//One of the blank columns will be used to move cards to so it can't be considered a blank column.
//						availableCells = blankColumns + blankFreecells + (blankColumns * blankFreecells) + 1;
//						availableCells = (1 + blankFreecells)*2^blankColumns;
						availableCells = (1 + blankFreecells)*pow(2,blankColumns);
//						cout << "used the new formula";
						if(availableCells < counter)
						{
//							goodMove = false;
//							badMoveString = "not enough freecells plus empty columns to make that move";
							counter = availableCells;
						}
					}//closes if(dest column is blank
					else//IOW, if(dest column is NOT blank
					{
						keepLooping = true; //Probably already is.  Sue me for being redundant redundantly.
						while(keepLooping)
						{
						Card theCardBeingChecked = Card(theColumns[componentsOfUserInput[1]][cardsInColumns[componentsOfUserInput[1]]-1-counter].getNumber(),theColumns[componentsOfUserInput[1]][cardsInColumns[componentsOfUserInput[1]]-1-counter].getSuit());
						Card theCardAbove = Card(theColumns[componentsOfUserInput[1]][cardsInColumns[componentsOfUserInput[1]]-2-counter].getNumber(),theColumns[componentsOfUserInput[1]][cardsInColumns[componentsOfUserInput[1]]-2-counter].getSuit());
						Card theLastCardOnDestColumn = Card(theColumns[componentsOfUserInput[3]][cardsInColumns[componentsOfUserInput[3]]-1].getNumber(),theColumns[componentsOfUserInput[3]][cardsInColumns[componentsOfUserInput[3]]-1].getSuit());
						if(!(willStackInColumnFashion(theLastCardOnDestColumn, theCardBeingChecked))and !(willStackInColumnFashion(theCardAbove, theCardBeingChecked)))//IOW, neither the card above is a match nor the last card on the dest is a match.  IOOW, the move is bad.
							{
								goodMove = false;
								keepLooping = false;
								badMoveString = "invalid move";
							}

						if(keepLooping and willStackInColumnFashion(theLastCardOnDestColumn,theCardBeingChecked))
							{
								counter++;
								keepLooping = false;
							}
						if(keepLooping and willStackInColumnFashion(theCardAbove,theCardBeingChecked))//IOW, the move may still be good, keep checking.  IOOW, don't do nothin'
							{
								counter++;
							}
						}//closes while(keepLooping
//--------------------------right here I'll have to determine how many cards can be moved based on freecells and free columns.-----------
//						availableCells = blankColumns + blankFreecells + (blankColumns * blankFreecells) + 1;
//						availableCells = (1 + blankFreecells) * 2^blankColumns;
						availableCells = (1 + blankFreecells) * pow(2.0,blankColumns);
//						cout << "used new improved formula";
						if(availableCells < counter)
						{
							goodMove = false;
							badMoveString = "not enough freecells plus empty columns to make that move";
						}
					}//closes else IOW dest column is NOT blank
				}//closes if COUI[0] = 2
				if(componentsOfUserInput[0]==0)//0 = freecell, OK?
				{
					Card theCardToPlaceOnto = Card(theColumns[componentsOfUserInput[3]][cardsInColumns[componentsOfUserInput[3]]-1].getNumber(),theColumns[componentsOfUserInput[3]][cardsInColumns[componentsOfUserInput[3]]-1].getSuit());
					Card theCardToPlace = Card(theFreecells[componentsOfUserInput[1]].getNumber(),theFreecells[componentsOfUserInput[1]].getSuit());
					if(!(willStackInColumnFashion(theCardToPlaceOnto, theCardToPlace))and cardsInColumns[componentsOfUserInput[3]] != 0)
					{
						goodMove = false;
						badMoveString = "invalid move";
					}//closes if(NOTwillStack
				}//closes if(COUI==0
			}//closes if(UI = c
			if(goodMove)
			{
				moveCards();
			}
			else
			{
				cout << endl << badMoveString << endl;
				cout << '\a';
			}
			updateDisplay();
		}//closes if(goodMove way above
	}//closes while(1)
}//closes getUserInteraction

string convertToCardNumber(int sentNumber)
{
	switch(sentNumber)
	{
		case 0:
			return " A";
		case 1:
			return " 2";
		case 2:
			return " 3";
		case 3:
			return " 4";
		case 4:
			return " 5";
		case 5:
			return " 6";
		case 6:
			return " 7";
		case 7:
			return " 8";
		case 8:
			return " 9";
		case 9:
			return "10";
		case 10:
			return " J";
		case 11:
			return " Q";
		case 12:
			return " K";
		case -1:
			return "  ";
	}
	return "";//never get here.  The compiler is afraid it might.
}

string convertToCardSuit(int sentSuit)
{
	switch (sentSuit)
	{
		case 0:
			return "♣️";
		case 1:
			return "♦️";
		case 2:
			return "♥️";
		case 3:
			return "♠️";
		case -1:
			return " ";
	}
	return "";//never get here.  The compiler is afraid it might.
}

void moveCards()//0 = freecells, 1 = stacks, 2 = columns
{
	if(componentsOfUserInput[0] == 2 and componentsOfUserInput[2] == 2)//IOW, move column to column
	{
//		cout << endl << "The number of cards I intend to move is " << counter << "." << endl;
		if(counter == 1)
		{
			cout << "Successful move of 1 card." << endl;
		}
		else
			cout << "Successful move of " << counter << " cards." << endl;
		for(int i = 0;i < counter;i++)
		{
			Card CardForMoving;
			int sourceIndex = cardsInColumns[componentsOfUserInput[1]] - 1;//this is the index of last card in the source column
			int destIndex = cardsInColumns[componentsOfUserInput[3]] - 1;//this is the index of the last card in the destination column
			CardForMoving = Card(theColumns[componentsOfUserInput[1]][sourceIndex - i].getNumber(),theColumns[componentsOfUserInput[1]][sourceIndex - i].getSuit());
			theColumns[componentsOfUserInput[1]][sourceIndex - i].removeCard();
			theColumns[componentsOfUserInput[3]][destIndex + (counter - i)].placeCard(CardForMoving);
		}//closes for(
		cardsInColumns[componentsOfUserInput[1]]=cardsInColumns[componentsOfUserInput[1]] - counter;
		cardsInColumns[componentsOfUserInput[3]]=cardsInColumns[componentsOfUserInput[3]] + counter;
	}//closes if(COUI[0]=2 and COUI[2]=2
	else//IOW, not column to column, IOOW, move only 1 card
	{
		Card tempCard;
		if(componentsOfUserInput[0] == 0)//moving from freecells
		{
			tempCard = Card(theFreecells[componentsOfUserInput[1]].getNumber(),theFreecells[componentsOfUserInput[1]].getSuit());
			theFreecells[componentsOfUserInput[1]].removeCard();
		}//closes if(COUI[0] = 0
		else if(componentsOfUserInput[0] == 2)//moving from columns
		{

			int lastCardIndex = cardsInColumns[componentsOfUserInput[1]] - 1;
			tempCard = Card(theColumns[componentsOfUserInput[1]][lastCardIndex].getNumber(),theColumns[componentsOfUserInput[1]][lastCardIndex].getSuit());
			theColumns[componentsOfUserInput[1]][cardsInColumns[componentsOfUserInput[1]]-1].removeCard();
			cardsInColumns[componentsOfUserInput[1]]--;
		}//closes if(COUI[0] = 2
//-----------------------above is deleting the card from its original location, below is moving to the new location------------
		if(componentsOfUserInput[2] == 0)//IOW, move to freecell
		{
			theFreecells[componentsOfUserInput[3]].placeCard(tempCard);
		}
		else if(componentsOfUserInput[2] == 1)//IOW, move to stack
		{//12 = KING, 0 = ACE
			theStacks[tempCard.getSuit()].placeCard(tempCard);
			if(tempCard.getNumber() > cleanLevel and sentCleanMessage==false)
			{
				stillClean = false;
				cout << endl << "No longer playing clean." << endl;
				sentCleanMessage = true;
			}
			if(theStacks[0].getNumber() == theStacks[1].getNumber() and theStacks[1].getNumber() == theStacks[2].getNumber() and theStacks[2].getNumber() == theStacks[3].getNumber() and tempCard.getNumber() > 0)
			{
				cleanLevel++;
//				cout << endl << "Clean level is " << cleanLevel;
			}
			if(theStacks[0].getNumber() == 12 and theStacks[1].getNumber() == 12 and theStacks[2].getNumber() == 12 and theStacks[3].getNumber() == 12)
			{
				cout << endl << endl << "Y O U   W I N!!\a" << endl;
				if(stillClean)//IOW if stillClean==true
				{
					cout << endl << "and you played CLEAN!" << endl;
				}//closes if(stillClean)
				updateDisplay();
				endSeconds = time(NULL);
				int minutes = (endSeconds - startSeconds) / 60;
				int seconds = (endSeconds - startSeconds) % 60;
//				cout << "\nGame took " << endSeconds - startSeconds << " seconds.\n";
				cout << "\nGame took " << minutes << " minutes and " << seconds << " seconds.\n";
				exit(0);
			}
		}//closes else if(==1, IOW move to stack
		else if(componentsOfUserInput[2] == 2)//IOW, move to column--this might also be correct if I just said else or maybe no condition at all since there are only 3 choices and the other 2 have already been checked.  Sue me for overkill.
		{
			theColumns[componentsOfUserInput[3]][cardsInColumns[componentsOfUserInput[3]]].placeCard(tempCard);
			cardsInColumns[componentsOfUserInput[3]]++;
		}
	}//closes else, IOW, closes the area where only 1 card is moved.
	return;
}

bool willStackInColumnFashion(Card stationaryCard,Card movingCard)
{
	if(stationaryCard.getNumber() == movingCard.getNumber()+1 and stationaryCard.getColor() != movingCard.getColor())
	{
		return true;
	}
	else
	{
		return false;
	}
}//closes willStackInColumnFashion()

bool willStackInStackFashion(cardSpot stationaryCard,cardSpot wantsToMoveCard)
{
	if(stationaryCard.getSuit() == wantsToMoveCard.getSuit() and stationaryCard.getNumber() == wantsToMoveCard.getNumber() - 1)
	{
		return true;
	}
	else
	{
		return false;
	}
}//closes willStackInStackFashion

/*
So far I have checked validity of 
 from column -- if column is blank
 from freecell checked if frecell is blank
 to freecell -- if no empty freecell available
*/
